
import cadquery as cq

# Define the dimensions
width = 0.04
height = width / 20
square_side = width / 2
extrude_depth = 20 * width

# Create the base rectangle
rectangle = cq.Workplane("front").rect(width, height)

# Create the first square on top of the rectangle
first_square = rectangle.rect(square_side, square_side).translate((square_side/2, height))

# Create the second square on top of the first square
second_square = first_square.rect(square_side*0.99,square_side*0.99).translate(((square_side*0.99/2), square_side))

# Extrude the sketch to create the 3D object
part = second_square.extrude(extrude_depth)

# Save the output
part.val().exportStl("Refine_2.stl")
