
import cadquery as cq

# Define the dimensions of the original rectangle and the cutout
length = 100.0  # Length of the original rectangle
width = 20.0  # Width of the original rectangle
thickness = 2.0  # Thickness of the original rectangle
cutout_length = length / 4.0  # Length of the cutout
cutout_width = width / 2.0  # Width of the cutout

# Define the cutout position
cutout_pos_x = length / 2.0  # X-Position of the cutout
cutout_pos_y = -width / 4.0  # Y-Position of the cutout

# Create the original rectangle
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Create the cutout
result = (
    result.faces(">Z")
    .workplane(centerOption="CenterOfMass")
    .move(cutout_pos_x, cutout_pos_y)
    .rect(cutout_length, cutout_width)
    .extrude(-thickness, combine=True)
)

# Export the result
result.val().exportStl("Refine_2.stl")
