
import cadquery as cq

# Define the dimensions
rect_width = 1.26
rect_height = 0.63
tri_height = 0.63
cutout_size = 0.1
extrude_amount = 0.1

# Create rectangle base
rect_base = cq.Workplane("front").rect(rect_width, rect_height)

# Add the triangle on top
rect_base = rect_base.moveTo(0, rect_height/2).lineTo(rect_width/2, rect_height/2 + tri_height).lineTo(-rect_width/2, rect_height/2).close()

# Cutout the bottom corners
rect_base = rect_base.moveTo(-rect_width/2, -rect_height/2).polyline([(cutout_size,0), (0, cutout_size), (-cutout_size,0)]).close()
rect_base = rect_base.moveTo(rect_width/2, -rect_height/2).polyline([(-cutout_size,0), (0, cutout_size), (cutout_size,0)]).close()

# Extrude the sketch to finally create plate
pentagon_plate = rect_base.extrude(extrude_amount)

# Save result
pentagon_plate.val().exportStl("Refine_2.stl")
