
import cadquery as cq

# Dimensions for the table
table_length = 1.0
table_width = 0.5
table_thickness = 0.05
leg_length = 0.2
leg_width = 0.1
leg_height = 0.5

# Create the table top
table = cq.Workplane("XY").box(table_length, table_width, table_thickness)

# Create the legs
leg1 = (
    cq.Workplane("XY")
    .workplane(offset=-table_thickness)
    .rect(leg_length, leg_width)
    .extrude(-leg_height)
)
leg2 = (
    cq.Workplane("XY")
    .workplane(offset=-table_thickness)
    .moveTo(table_length-leg_length, 0)
    .rect(leg_length, leg_width)
    .extrude(-leg_height)
)
leg3 = (
    cq.Workplane("XY")
    .workplane(offset=-table_thickness)
    .moveTo(0, table_width-leg_width)
    .rect(leg_length, leg_width)
    .extrude(-leg_height)
)
leg4 = (
    cq.Workplane("XY")
    .workplane(offset=-table_thickness)
    .moveTo(table_length-leg_length, table_width-leg_width)
    .rect(leg_length, leg_width)
    .extrude(-leg_height)
)

# Combine the table top and the legs
result = table.union(leg1).union(leg2).union(leg3).union(leg4)

# Export the result
result.val().exportStl("Refine_1.stl")
