
import cadquery as cq
import math

# Create a regular hexagon
hexagon = cq.Workplane("XY").polygon(6, 1.3).extrude(0.68)

# Create a smaller square on top of the hexagon
square = cq.Workplane("XY").workplane(offset=0.68).transformed(rotate=(0, 0, 45)).rect(1.3, 1.3).extrude(0.82)

# Combine the hexagon and the square
result = hexagon.union(square)

# Export the result
result.val().exportStl("Refine_1.stl")
