
import cadquery as cq
import math

# Create a regular hexagon
hexagon = cq.Workplane("XY").polygon(6, 1.5).extrude(1.5)

# Create a smaller square on top of the hexagon
square = cq.Workplane("XY").workplane(offset=1.5).transformed(rotate=(0, 0, 45)).rect(1.84, 1.84).extrude(1.5)

# Combine the hexagon and the square
result = hexagon.union(square)

# Export the result
result.val().exportStl("Refine_2.stl")
