
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(0.94, 1.5).extrude(0.7)

# Create the L-shaped block
l_block = (
    cq.Workplane("XY")
    .workplane(offset=0.7)
    .moveTo(-0.47, 0.75)
    .lineTo(0.47, 0.75)
    .lineTo(0.47, 0.35)
    .lineTo(-0.47, 0.35)
    .close()
    .extrude(0.7)
)

# Combine the base and the L-shaped block
result = base.union(l_block)

# Save the output
result.val().exportStl("Refine_2.stl")
