
import cadquery as cq

# Define the dimensions
circle_diameter = 10.0
rectangle_width = 1.0
rectangle_height = 7.0
hole_diameter = 0.5
extrude_depth = 2.0

# Create the workplane that the object will be built on
result = cq.Workplane("front")

# Draw the circle
result = result.circle(circle_diameter / 2.0)

# Draw the rectangle
result = result.moveTo(0, -circle_diameter / 2.0) \
    .rect(rectangle_width, rectangle_height, centered=False)

# Draw the hole
result = result.moveTo(0, rectangle_height / 2.0 - hole_diameter) \
    .circle(hole_diameter / 2.0)

# Extrude to create the 3D object
result = result.extrude(extrude_depth)

# Export the result
result.val().exportStl("Generated.stl")
