
import cadquery as cq

# Create a rectangular plate
plate = cq.Workplane("XY").box(80, 20, 5)

# Create two square cutouts with rounded edges
cutout1 = (
    plate.faces(">Z")
    .workplane(offset=-5)
    .rect(10, 10, forConstruction=False)
    .extrude(5)
    .edges("|Z")
    .fillet(2)
)

cutout2 = (
    plate.faces(">Z")
    .workplane(offset=-5)
    .moveTo(70, 0)
    .rect(10, 10, forConstruction=False)
    .extrude(5)
    .edges("|Z")
    .fillet(2)
)

# Combine the plate and the cutouts using the cut operation
result = plate.cut(cutout1).cut(cutout2)

# Export the result
result.val().exportStl("Refine_1.stl")
