
import cadquery as cq

# Define the dimensions
base_small = 20.0  # Small base of the trapezium
base_large = 30.0  # Large base of the trapezium
height = 15.0  # Height of the trapezium
extrude_amount = 100.0  # Amount to extrude the trapezium

# Create the trapezium sketch
r = cq.Workplane("front").lineTo(base_small/2, 0).lineTo(base_large/2, height).lineTo(-base_large/2, height).lineTo(-base_small/2, 0).close()

# Extrude the sketch to create the prism
result = r.extrude(extrude_amount)

# Export the result
result.val().exportStl("Refine_1.stl")
