
import cadquery as cq

# Define the dimensions from the feedback
base_small = 30.0  # Refined small base of the trapezium
base_large = 60.0  # Refined large base of the trapezium
height = 30.0  # Refined height of the trapezium
extrude_amount = 200.0  # Refined amount to extrude the trapezium

# Create the trapezium sketch
r = cq.Workplane("front").lineTo(base_small/2, 0).lineTo(base_large/2, height).lineTo(-base_large/2, height).lineTo(-base_small/2, 0).close()

# Extrude the sketch to create the prism
result = r.extrude(extrude_amount)

# Export the result
result.val().exportStl("Refine_2.stl")
