
import cadquery as cq

# Define the dimensions
length_vertical = 100.0
width = 20.0
thickness = 5.0
length_horizontal = length_vertical / 4

# Create the vertical rectangle
result = cq.Workplane("front").rect(width, length_vertical).extrude(thickness)

# Create the horizontal rectangle
result = result.faces(">Z").workplane().center(0, length_vertical / 4).rect(width, length_horizontal).extrude(thickness)

# Export the result
result.val().exportStl("Refine_1.stl")
