
import cadquery as cq

# Define the points for the irregular pentagon
points = [(0, 0), (2, 1), (1, 3), (-1, 3), (-2, 1)]

# Create the workplane and draw the pentagon
r = cq.Workplane("front").polyline(points).close()

# Extrude the sketch to create the 3D pentagonal prism
result = r.extrude(5)

# Save the output
result.val().exportStl("Refine_1.stl")
