
import cadquery as cq
import math

# Define the side length of the equilateral triangle
side_length = 10.0

# Calculate the height of the equilateral triangle
height = side_length * math.sqrt(3) / 2

# Define the radius of the semicircular cutout
radius = side_length * 2 / 3 / 2

# Define the points of the equilateral triangle
pts = [
    (-side_length / 2, -height / 2),
    (side_length / 2, -height / 2),
    (0, height / 2),
]

# Create the workplane and draw the triangle
result = cq.Workplane("front").polyline(pts).close()

# Cutout the semicircle from the bottom corner of the triangle
result = result.moveTo(0, -height / 2).threePointArc((-radius, -height / 2 + radius), (0, -height / 2 + 2 * radius))

# Extrude the sketch to create a 3D object
result = result.extrude(10.0)

# Export the result
result.val().exportStl("Refine_2.stl")
