
import cadquery as cq

# Define the dimensions
length = 13.5
width1 = 5.0
width2 = 3.0
height = 5.0
hole_diameter = 1.0

# Create the base rectangle
result = cq.Workplane("XY").rect(length, width1).extrude(height)

# Create the smaller rectangle on top
result = result.faces(">Z").workplane().center(length/2 - width2/2, 0).rect(length, width2).extrude(height)

# Create the hole through the center
result = result.faces(">Z").workplane().center(0, 0).hole(hole_diameter)

# Export the result
result.val().exportStl("Refine_2.stl")
