
import cadquery as cq

# Create the sketch of the irregular rhombus and close it
rhombus = cq.Workplane("front").polyline([(0, 0), (2, 4), (4, 0), (2, -4)]).close()

# Extrude the rhombus
rhombus = rhombus.extrude(1)

# Create the sketch of the rectangular prism
rect_prism = cq.Workplane("front").box(1, 1, 2)

# Translate the rectangular prism to the center of one of the extruded edges on the rhombus
rect_prism = rect_prism.translate((2, 0, 0.5))

# Combine the two shapes
result = rhombus.union(rect_prism)

# Export the result
result.val().exportStl("Refine_1.stl")
