
import cadquery as cq

# Create the first rectangle
first_rectangle = cq.Workplane("front").rect(10, 20).extrude(1)

# Create the second rectangle, starting halfway up the first one
second_rectangle = cq.Workplane("front").moveTo(0,10).rect(5, 10).extrude(1)

# Combine the two rectangles
result = first_rectangle.union(second_rectangle)

# Export the result
result.val().exportStl("Generated.stl")
