
import cadquery as cq

# Parameters for the cylinder
diameter = 10  # Diameter of the cylinder
height = 20  # Height of the cylinder

# Create the main cylinder
cylinder = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Calculate the width and length of the cut (1/4th of the original dimensions)
cut_width = diameter * 0.25
cut_length = height * 0.25

# Create a cutting tool that removes 1/4th the length and diameter
# We use a box for simplicity and position it such that 1/4th of the top surface is removed
cutting_tool = (cq.Workplane("front")
                .box(cut_width, diameter, cut_length)  # width, depth (full cylinder), height
                .translate((diameter * 0.75, 0, height - cut_length / 2.0)))  # position the box correctly

# Cut the portion from the cylinder
final_result = cylinder.cut(cutting_tool)

# Export the result in STL
final_result.val().exportStl("Refine_2.stl")
