
import cadquery as cq

# Define the points of the triangle
points = [(0, 0), (1, 2), (2, 0)]

# Create the workplane and the triangle
result = cq.Workplane("XY").polyline(points).close()

# Extrude the triangle
result = result.extrude(1.0)

# Export the result with the new file name as specified
result.val().exportStl("Refine_1.stl")
