
import cadquery as cq

# Define the dimensions
length = 10.0
width = 5.0
height = 0.5

# Create the first rectangle
result = cq.Workplane("XY").box(length, width, height)

# Create the second rectangle perpendicular to the first one.
# It should be created on the edge and align such that it mimics wall-floor intersection
# Fixed rotation and ensured alignment along the edge
result = result.faces(">Z").workplane().transformed(offset=(-width/2, 0, height/2), rotate=(90, 0, 0)).box(length, width, height)

# Export the result
result.val().exportStl("Refine_1.stl")
