
import cadquery as cq

# Define the dimensions of the main rectangle and the cut-out
main_length = 10.0
main_width = 5.0
main_height = 0.5
cutout_length = 4.0
cutout_width = 2.0
cutout_height = 0.5

# Create the main rectangle
result = cq.Workplane("XY").box(main_length, main_width, main_height)

# Centering the cut-out at the exact midpoint of the main rectangle's length and slightly above the midpoint of its width
# The midpoint of main_length is main_length / 2, and the midpoint of main_width is main_width / 2
# Since we need the cutout to be slightly above the midpoint (e.g., +0.1 units), we adjust accordingly

# Correcting the center position to be exactly in the middle lengthwise and slightly offset widthwise
result = result.faces(">Z").workplane().center(0, 0.1).rect(cutout_length, cutout_width).cutThruAll()

# Export the result
result.val().exportStl("Refine_2.stl")
