
import cadquery as cq

# Create the first cylinder
cylinder1 = cq.Workplane("XY").circle(10).extrude(20)

# Create the second cylinder
cylinder2 = cq.Workplane("XY").circle(5).extrude(20)

# Create the third cylinder
cylinder3 = cq.Workplane("XY").circle(15).extrude(10)

# Combine the cylinders
result = cylinder1.union(cylinder2.translate((0, 0, 20))).union(cylinder3.translate((0, 0, 40)))

# Create the cutout
cutout = cq.Workplane("XY").circle(2).extrude(50)

# Subtract the cutout from the result
result = result.cut(cutout)

# Export the result
result.val().exportStl("Generated.stl")
