
import cadquery as cq

# Define the parameters of the rounded rectangle
length = 10.0
width = 5.0
corner_radius = 1.0
extrude_height = 1.0

# Create a workplane
result = cq.Workplane("XY")

# Draw a rectangle and extrude it to create a solid
result = (
    result.rect(length, width)
    .extrude(extrude_height)
)

# Apply fillet on the corners of the rectangle
result = result.edges("|Z").fillet(corner_radius)

# Export the result - make sure to adjust the export line according to your environment setup, might need a local or cloud file handling
result.val().exportStl("Refine_1.stl")
