
import cadquery as cq

# Re-defined points of the obtuse scalene triangle
# Changed the third point to ensure an obtuse angle (>90 degrees)
points = [(0, 0), (4, 0), (0.5, 2.5)]

# Create the triangle
result = cq.Workplane("XY").polyline(points).close().extrude(1.0)

# Export the result with the adjusted filename
result.val().exportStl("Refine_2.stl")
