
import cadquery as cq

# Define the dimensions of the rectangle
length = 100.0  # Length of the rectangle
width = 50.0  # Width of the rectangle
thickness = 1.0  # Thickness of the rectangle

# Create the rectangle and extrude it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Export the result
result.val().exportStl("Generated.stl")
