
import cadquery as cq

# Define the dimensions of the rectangle and the holes
length = 100.0  # Length of the rectangle
width = 50.0  # Width of the rectangle
thickness = 10.0  # Thickness of the rectangle
hole_dia = 5.0  # Diameter of the holes
hole_offset = 10.0  # Distance from the corners to the center of the holes

# Create the rectangle
result = (
    cq.Workplane("XY")
    .box(length, width, thickness)
)

# Create the holes
for x in (-length / 2 + hole_offset, length / 2 - hole_offset):
    for y in (-width / 2 + hole_offset, width / 2 - hole_offset):
        result = result.faces(">Z").workplane().center(x, y).hole(hole_dia)

# Export the result
result.val().exportStl("Generated.stl")
