
import cadquery as cq

# Define the dimensions of the rectangle
length = 10.0
width = 5.0
thickness = 2.0

# Create the rectangle and extrude it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Ensuring that the dimensions are accurate
assert result.val().BoundingBox().xmax - result.val().BoundingBox().xmin == length, "Length is not as expected."
assert result.val().BoundingBox().ymax - result.val().BoundingBox().ymin == width, "Width is not as expected."
assert result.val().BoundingBox().zmax - result.val().BoundingBox().zmin == thickness, "Thickness is not as expected."

# Export the result to an STL file with refined filename
result.val().exportStl("Refine_2.stl")
