
import cadquery as cq

# Create a long rectangular prism
result = cq.Workplane("XY").box(100, 20, 20)

# Cut out a semi-circle shape from the length of the rectangular prism
# Cutting should be along the side, and should only be half a circle (i.e., a semi-circle)
result = result.faces(">Z").workplane().center(0, 0)\
         .rect(100, 20, centered=False).cutBlind(-10)\
         .faces(">Z").workplane().center(-50, 0).circle(10).cutBlind(-10)

# Save the output with updated filename
result.val().exportStl("Refine_1.stl")
