
import cadquery as cq

# Create a long rectangular prism
result = cq.Workplane("XY").box(100, 20, 20)

# Cut out a semi-circle shape from one of the long faces of the rectangular prism
# Cutting the semi-circle from the length
semi_circle_diameter = 20
result = result.faces(">Y").workplane().center(0, 0)\
                .circle(semi_circle_diameter / 2).cutThruAll()

# Save the output with the updated filename
result.val().exportStl("Refine_2.stl")
