
import cadquery as cq

# Adjusted parameters for the cylinder and hole
diameter = 200.0  # Increased diameter of the cylinder for a "very large" appearance
height = 10.0  # Height of the cylinder remains the same
hole_diameter = 10.0  # Diameter of the hole remains the same

# Create the cylinder
result = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Create the hole
result = result.faces(">Z").workplane().hole(hole_diameter)

# Export the adjusted model
result.val().exportStl("Refine_1.stl")
