
import cadquery as cq

# Define the dimensions of the table and legs
table_length = 90.0
table_width = 60.0
table_thickness = 2.0

leg_length = 30.0  # table_length / 3
leg_height = table_thickness  # Same extrusion as the table thickness
leg_width = 5.0

# Create the table surface
table = cq.Workplane("XY").box(table_length, table_width, table_thickness)

# Create the legs (for correct placement right below the table surface)
leg1 = (
    cq.Workplane("XY")
    .workplane(offset=-table_thickness)
    .moveTo(-table_length / 2 + leg_length / 2, -table_width / 2 + leg_width / 2)
    .box(leg_length, leg_width, leg_height, centered=(True, True, False))
)

leg2 = (
    cq.Workplane("XY")
    .workplane(offset=-table_thickness)
    .moveTo(table_length / 2 - leg_length / 2, -table_width / 2 + leg_width / 2)
    .box(leg_length, leg_width, leg_height, centered=(True, True, False))
)

# Combine the table surface and the legs
result = table.union(leg1).union(leg2)

# Export the result as STL
result.val().exportStl("Refine_2.stl")
