
import cadquery as cq

# Define dimensions
rect_length = 30.0
rect_width = 10.0
rect_height = 5.0

# Calculate side of small and large squares
small_square_side = 2.0
# Calculate the large square based on being 75% larger in area than the small square
large_square_side = small_square_side / (0.25**0.5) 

# Heights of squares, large square being twice as tall
small_square_height = 5.0
large_square_height = small_square_height * 2

# Create main rectangle
result = cq.Workplane("XY").box(rect_length, rect_width, rect_height)

# To ensure squares connect flush with the ends and centered vertically, translate to proper position
# Create small square on the left
result = result.faces("<X").workplane(centerOption="CenterOfBoundBox").center(0, rect_height/2 - small_square_height/2).box(small_square_side, small_square_side, small_square_height, combine=True)

# Create large square on the right
result = result.faces(">X").workplane(centerOption="CenterOfBoundBox").center(0, rect_height/2 - large_square_height/2).box(large_square_side, large_square_side, large_square_height, combine=True)

# Export the result
result.val().exportStl("Refine_1.stl")
