
import cadquery as cq

# Define dimensions
rect_length = 30.0
rect_width = 10.0
rect_height = 5.0

# Calculate the side length of the small square so that it's 75% smaller in area compared to the large one
# small_square_area = large_square_area / 4 implies small_square_side^2 = (large_square_side^2) / 4
# Thus, small_square_side = large_square_side / 2
large_square_side = 4.0
small_square_side = large_square_side / 2.0

# Heights of squares, large square being twice as tall
small_square_height = 5.0
large_square_height = small_square_height * 2

# Create main rectangle
result = cq.Workplane("XY").box(rect_length, rect_width, rect_height)

# Adjust calculation for squares to place them flush centered vertically
# Create small square on the left
result = result.faces("<X").workplane(centerOption="CenterOfBoundBox").center(0, -(rect_height/2 - small_square_height/2)).box(small_square_side, small_square_side, small_square_height, combine=True)

# Create large square on the right
result = result.faces(">X").workplane(centerOption="CenterOfBoundBox").center(0, -(rect_height/2 - large_square_height/2)).box(large_square_side, large_square_side, large_square_height, combine=True)

# Export the result with the adjusted code
result.val().exportStl("Refine_2.stl")
