
import cadquery as cq
import math

# Define the side length of the hexagon
side_length = 10.0

# Calculate the radius of the circumscribed circle
radius = side_length / math.sqrt(3)

# Create a workplane
result = cq.Workplane("XY")

# Draw the hexagon using polar coordinates
points = [(radius * math.cos(math.radians(angle)), radius * math.sin(math.radians(angle))) 
          for angle in range(0, 360, 60)]
result = result.polyline(points).close()

# Extrude to create a 3D object
result = result.extrude(5.0)

# Export the result to STL with updated file name
result.val().exportStl("Refine_2.stl")
