
import cadquery as cq

# Create the first rectangle and extrude it
result = cq.Workplane("front").rect(10, 5).extrude(1)

# Create the second rectangle on top of the first one with slightly smaller widths
result = result.faces(">Z").workplane().rect(8, 5).extrude(1)

# Create the trapezoid on top of the second rectangle
# Correcting the points to ensure it's wider than the second rectangle and centers correctly
result = result.faces(">Z").workplane().polyline([(-4.5, 0), (4.5, 0), (5, 2), (-5, 2)]).close().extrude(1)

# Save the output
result.val().exportStl("Refine_1.stl")
