
import cadquery as cq

# Create the first rectangle and extrude it
result = cq.Workplane("front").rect(10, 5).extrude(1)

# Create the second rectangle on top of the first one with slightly smaller widths
result = result.faces(">Z").workplane().rect(8, 5).extrude(1)

# Create the trapezoid on top of the second rectangle
# Ensure slightly longer width than the second rectangle (8 + 0.5 * 2 = 9)
# Centrally align the trapezoid over the second rectangle
trapezoid_width_top = 9
trapezoid_width_bottom = 8
trapezoid_vertical_height = 2
result = result.faces(">Z").workplane()\
    .polyline([(-(trapezoid_width_bottom/2), 0), (trapezoid_width_bottom/2, 0), 
               (trapezoid_width_top/2, trapezoid_vertical_height), 
               (-(trapezoid_width_top/2), trapezoid_vertical_height)])\
    .close()\
    .extrude(1)

# Save the output
result.val().exportStl("Refine_2.stl")
