
import cadquery as cq

# Create a short cylinder with a large diameter
cylinder = cq.Workplane("XY").circle(10.0).extrude(5.0)

# Create a short and narrow rectangular prism
rect_prism = cq.Workplane("XY").box(12.0, 2.0, 2.0)

# Adjust the position of the rectangular prism to be perfectly centered on the cylinder
# Calculate the needed shift to center the prism on the cylinder's top face
# Here, the rectangular prism height is already provided as 2.0, it sits on top cylinder height of 5.0
rect_prism = rect_prism.translate((0, 0, 5.0 + 1.0))  # Adjust the z-translation to center it vertically on the cylinder's top surface

# Combine the two shapes
result = cylinder.union(rect_prism)

# Export the result with the revised file name
result.val().exportStl("Refine_2.stl")
