
import cadquery as cq

# Define dimensions
rectangle_length = 15.0
rectangle_width = 10.0
rectangle_thickness = 0.5
rod_width = 1.0
rod_length = 1.0
rod_height = 3 * rectangle_length

# Create the base rectangle
result = (
    cq.Workplane("XY")
    .rect(rectangle_length, rectangle_width)
    .extrude(rectangle_thickness)
)

# Modify this section to move the rod to a corner of the rectangle
# Assuming the -X, -Y corner is the targeted corner
result = (
    result
    .faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")
    .transformed(offset=(rectangle_length/2 - rod_length/2, -rectangle_width/2 + rod_width/2, 0))
    .rect(rod_length, rod_width)
    .extrude(rod_height)
)

# Export the result with the proper file name
result.val().exportStl("Refine_1.stl")
