
import cadquery as cq

# Define the dimensions
width = 10.0  # Width of the square
length = width  # Length must be the same as width for a square

# Create a square using the equal dimensions and extrude it
result = (
    cq.Workplane("XY")
    .rect(length, width)  # This now creates a square as length = width
    .extrude(5.0)  # Extrude the square to create a 3D object
)

# Save the output
result.val().exportStl("Refine_1.stl")
