
import cadquery as cq

# Define the dimensions of the original and cutout prisms
length = 100.0
width = 20.0
height = 20.0
cutout_length = length / 4
cutout_height = height * 3 / 4

# Create the original prism
result = cq.Workplane("XY").box(length, width, height)

# Create the cutout prism
cutout = (
    cq.Workplane("XY")
    .workplane(offset=0)
    .moveTo(length - cutout_length / 2, 0)  # Correct the position to the right side
    .rect(cutout_length, width)
    .extrude(cutout_height)
)

# Subtract the cutout from the original prism
result = result.cut(cutout)

# Export the result
result.val().exportStl("Refine_1.stl")
