
import cadquery as cq

# Create a workplane
result = cq.Workplane("front")

# Draw the outline of the plate
result = result.moveTo(-5, 0).lineTo(5, 0).threePointArc((5.5, 0.5), (5, 1)).lineTo(-5, 1).threePointArc((-5.5, 0.5), (-5, 0))

# Extrude it to create the plate
result = result.close().extrude(0.1)

# Create the holes
result = result.faces(">Z").workplane().center(4.5, 0.5).hole(0.5).center(-4.5, 0.5).hole(0.5)

# Export the result
result.val().exportStl("Generated.stl")
