
import cadquery as cq

# Define the dimensions of the plate and holes
plate_length = 100.0
plate_width = 50.0
plate_thickness = 10.0
hole_diameter = 5.0
hole_offset = 10.0  # Ensure the offset is from the centerline

# Create the plate
result = (
    cq.Workplane("XY")
    .box(plate_length, plate_width, plate_thickness)
)

# Cut the holes with corrected symmetry
result = (
    result.faces(">Z")
    .workplane()
    .center(-hole_offset, 0)  # Center of the first hole
    .hole(hole_diameter)
    .center(2 * hole_offset, 0) # Move to the other side for the second hole
    .hole(hole_diameter)
)

# Export the result
result.val().exportStl("Refine_1.stl")
