
import cadquery as cq

# Define the dimensions of the plate and holes
plate_length = 100.0
plate_width = 50.0
plate_thickness = 10.0
hole_diameter = 5.0
hole_offset = 10.0  # This is the offset of the holes from the center of the plate along its length

# Create the plate
result = (
    cq.Workplane("XY")
    .box(plate_length, plate_width, plate_thickness)
)

# Cut the holes with corrected symmetry
result = (
    result.faces(">Z")
    .workplane()
    .center(-hole_offset, 0)  # Center of the first hole, left of the centerline
    .hole(hole_diameter)
    .moveTo(hole_offset * 2, 0) # Moving from left of centerline to right of centerline for the second hole
    .hole(hole_diameter)
)

# Export the corrected model
result.val().exportStl("Refine_2.stl")
