
import cadquery as cq

# Create a rectangle and extrude it
result = cq.Workplane("XY").rect(10, 20).extrude(5)

# Create a circle positioned above the midpoint of the rectangle and negatively extrude it to create a hole
result = result.faces(">Z").workplane().circle(2).cutThruAll()

# Adjust the position and length of the slit to start at the circle's center and move to the shorter edge of the rectangle
# The rectangle's shorter edge is 10 units long, so moving halfway (5 units) gets us to the edge directly.
result = result.faces(">Z").workplane().moveTo(0, 10).rect(0.2, 5, forConstruction=False).cutThruAll()

# Save the output with a new file name
result.val().exportStl("Refine_1.stl")
