
import cadquery as cq

# Create a workplane
result = cq.Workplane("front")

# Create a rectangle and extrude it
result = result.rect(10, 10).extrude(5)

# Create a large circle in the center of the rectangle and cut it
result = result.faces(">Z").workplane().hole(4)

# Move the positions of the two small circles further from the large circle
# Here, the horizontal distances are adjusted
result = result.faces(">Z").workplane().center(-5, 0).hole(1)
result = result.faces(">Z").workplane().center(5, 0).hole(1)

# Export the result to the updated name as specified
result.val().exportStl("Refine_1.stl")
