
import cadquery as cq

# Create a workplane
result = cq.Workplane("front")

# Create a rectangle and extrude it
result = result.rect(10, 10).extrude(5)

# Create a large circle in the center of the rectangle and cut it. 
# Adjusting the size for more prominence
result = result.faces(">Z").workplane().hole(6)  # Increased hole diameter for prominence

# Adjust positions of the two small circles, moving them further from the large circle
# Centering the workplane again before offsetting positions for small holes
result = result.faces(">Z").workplane().center(-3, 0).hole(1)
result = result.faces(">Z").workplane().center(3, 0).hole(1)

# Export the result with the correct file name
result.val().exportStl("Refine_2.stl")
