
import cadquery as cq

# Define the dimensions of the U-shape and the rectangle
U_width = 10.0
U_height = 20.0
U_thickness = 2.0
rectangle_width = U_width + 2*U_thickness
rectangle_height = U_thickness

# Create the U-shaped sketch
U_shape = cq.Workplane("front").moveTo(-U_width/2, 0).vLine(U_height).hLine(U_width).vLine(-U_height).close()

# Fill in the empty space of the U-shape
U_shape = U_shape.moveTo(-U_width/2 + U_thickness, U_thickness).vLine(U_height - 2*U_thickness).hLine(U_width - 2*U_thickness).vLine(-(U_height - 2*U_thickness)).close()

# Close the open part of the U-shape with a rectangle wider than the U's width
U_shape = U_shape.moveTo(-rectangle_width/2, 0).rect(rectangle_width, rectangle_height)

# Extrude this sketch to form a 3D object
result = U_shape.extrude(U_thickness)

# Save the output
result.val().exportStl("Generated.stl")
