
import cadquery as cq

# Create a cylinder with a height twice its diameter
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# To slice the cylinder, we need to intersect it with another shape. Let's create a box from (-20, -20, -2) to (20, 20, 2)
box = cq.Workplane("XY").box(40, 40, 4)

# Intersect the cylinder with the box to get a half-cylinder
half_cylinder = cylinder.intersect(box)

# Rotate the half-cylinder by 45 degrees
half_cylinder = half_cylinder.rotate((0,0,0), (1,0,0), 45)

# Cut through the half-cylinder with the rectangle
sliced_cylinder = half_cylinder.faces(">Z").workplane().rect(10, 20).cutThruAll()

sliced_cylinder.val().exportStl("Generated.stl")
