
import cadquery as cq

# Constants for the object creation
diameter = 10
height = 20

# Create the cylinder with the height twice of its diameter
cylinder = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Rotate the cylinder 45 degrees around the Y-axis for slicing
rotated_cylinder = cylinder.rotate((0, 0, 0), (0, 1, 0), 45)

# Create a cutting plane angled at 45 degrees
cutting_plane = cq.Workplane("YZ").box(height, diameter, diameter * 2, centered=(True, True, False)).translate((0, 0, height / 2))

# Slice the cylinder using the cutting plane
sliced_cylinder = rotated_cylinder.intersect(cutting_plane)

# Define the shape for removing 1/3rd of the material
# Determine cutting width as one third of the diameter and move the box to correct position
cutting_width = (diameter / 2) * 0.333
remove_material_box = cq.Workplane("XZ").box(cutting_width, diameter, height).translate((diameter / 4 - cutting_width / 2, 0, height / 2))

# Remove the material from the rotated and sliced cylinder using the cutting box
final_shape = sliced_cylinder.cut(remove_material_box)

# Save the STL file
final_shape.val().exportStl("Refine_2.stl")
