
import cadquery as cq

# Define the main body of the bench, resembles the crossbar in "h"
main_body = cq.Workplane("XY").rect(10, 3)

# Define the legs and backrest, give the appearance of vertical posts in 'h'
legs_backrest = cq.Workplane("XY", origin=(0, 5)).rect(1, 9).moveTo(5, 0).rect(1, 9)

# Combine the parts
bench = (main_body.add(legs_backrest)
         .extrude(1))  # Extrusion height for creating a 3D appearance

# Export the result
bench.val().exportStl("Refine_1.stl")
